var gPromptService;
var gFindBundle;

// browser is the <browser> element
// rootSearchWindow is the window to constrain the search to (normally window._content)
// startSearchWindow is the frame to start searching (can be, and normally, rootSearchWindow)
function findInPage(browser, rootSearchWindow, startSearchWindow)
{
  var findInst = browser.webBrowserFind;
  // set up the find to search the focussedWindow, bounded by the content window.
  var findInFrames = findInst.QueryInterface(Components.interfaces.nsIWebBrowserFindInFrames);
  findInFrames.rootSearchFrame = rootSearchWindow;
  findInFrames.currentSearchFrame = startSearchWindow;

  // always search in frames for now. We could add a checkbox to the dialog for this.
  findInst.searchFrames = true;
  
  // is the dialog up already?
  if ("findDialog" in window && window.findDialog)
    window.findDialog.focus();
  else
    window.findDialog = window.openDialog("chrome://global/content/finddialog.xul", "_blank", "chrome,resizable=no,dependent=yes", findInst);
}

function findAgainInPage(browser, rootSearchWindow, startSearchWindow, reverse)
{
  if ("findDialog" in window && window.findDialog)
    window.findDialog.focus();
  else
  {
    var findInst = browser.webBrowserFind;
    // set up the find to search the focussedWindow, bounded by the content window.
    var findInFrames = findInst.QueryInterface(Components.interfaces.nsIWebBrowserFindInFrames);
    findInFrames.rootSearchFrame = rootSearchWindow;
    findInFrames.currentSearchFrame = startSearchWindow;

    // always search in frames for now. We could add a checkbox to the dialog for this.
    findInst.searchFrames = true;

    // get the find service, which stores global find state, and init the
    // nsIWebBrowser find with it. We don't assume that there was a previous
    // Find that set this up.
    var findService = Components.classes["@mozilla.org/find/find_service;1"]
                           .getService(Components.interfaces.nsIFindService);
    findInst.searchString  = findService.searchString;
    findInst.matchCase     = findService.matchCase;
    findInst.wrapFind      = findService.wrapFind;
    findInst.entireWord    = findService.entireWord;
    findInst.findBackwards = findService.findBackwards ^ reverse;

    var found = false;
    if (findInst.searchString.length == 0) {
      // no previous find text
      findInPage(browser, rootSearchWindow, startSearchWindow);
      return;
    }

    found = findInst.findNext();
    if (!found) {
      if (!gPromptService)
        gPromptService = Components.classes["@mozilla.org/embedcomp/prompt-service;1"].getService()
                                   .QueryInterface(Components.interfaces.nsIPromptService);                                     
      if (!gFindBundle)
        gFindBundle = document.getElementById("findBundle");
          
      gPromptService.alert(window, gFindBundle.getString("notFoundTitle"), gFindBundle.getString("notFoundWarning"));
    }      

    // Reset to normal value, otherwise setting can get changed in find dialog
    findInst.findBackwards = findService.findBackwards; 
  }
}

function canFindAgainInPage()
{
    var findService = Components.classes["@mozilla.org/find/find_service;1"]
                           .getService(Components.interfaces.nsIFindService);
    return (findService.searchString.length > 0);
}

